<?php

namespace App\Http\Livewire\Admin\Descripcion;

use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\Servicio;
use App\Models\Descripcion;

class CreateDescripcion extends Component
{
    use WithFileUploads;
    
    public $open = false;
    public $title, $descripcion, $image, $servicio_id;  

    public function mount(){
        $this->identificador = rand();
    }
    protected $rules = [        
        'title' => 'required',
        'descripcion' => 'required',   
        'servicio_id' => 'required',      
        'image' => 'required|image'
    ];
    public function save(){

        $this->validate();
       
        $image = $this->image->store('descripcions', 'public');        

        Descripcion::create([            
            'title' => $this->title,
            'descripcion' => $this->descripcion,
            'servicio_id' => $this->servicio_id,
            'image' => $image
        ]);
        $this->reset(['open', 'title', 'descripcion', 'image', 'servicio_id']);
        $this->identificador = rand();
        $this->emit('render');
        $this->emit('alert', 'Añadio una nueva Descripcion');
    }
    public function render()
    {
        $servicios = Servicio::all();
        return view('livewire.admin.descripcion.create-descripcion', compact('servicios'));
    }
}
