<?php

namespace App\Http\Livewire\Admin\Descripcion;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Descripcion;
use App\Models\Servicio;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\Console\Descriptor\Descriptor;

class ShowDescripcion extends Component
{
    use WithPagination;
    use WithFileUploads;

    public $search, $descripcion, $image, $identificador;
    public $sort = 'id';
    public $direction = 'desc';
    public $confirmDelete = false;
    public $open_edit = false;

    public function mount(){
        $this->identificador = rand();
        $this->descripcion = new Descripcion();
    }
    public function updatingSearch(){
        $this->resetPage();
    }
    protected $listeners = ['render' => 'render', 'delete'];
    public function order($sort){
        if ($this->sort == $sort) {

            if($this->direction == 'desc'){
                $this->direction = 'asc';
            } else{
                $this->direction = 'desc';
            }
        } else {
            $this->sort = $sort;
            $this->direction = 'asc';
        }
      
    }

    protected $rules =[
        'descripcion.title' => 'required',
        'descripcion.descripcion' => 'required',
        'descripcion.servicio_id' => 'required',        
        // 'descripcion.image' => 'required|image'
    ];
    public function edit(Descripcion $descripcion){
        $this->descripcion = $descripcion;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->descripcion->image]);
            $this->descripcion->image = $this->image->store('descripcions', 'public');
        }
       
        $this->descripcion->save();
        $this->emit('render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo el Descripcion');

    
    }
    public function descripcionDelete($id){
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteDescripcion(Descripcion $descripcion){
        $descripcion->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        $servicios = Servicio::all();
        $descripcions = Descripcion::where('title','like', '%' .$this->search . '%')
        ->orwhere('descripcion','like', '%' .$this->search . '%')
        ->orwhere('servicio_id','like', '%' .$this->search . '%')   
        ->orderBy($this->sort, $this->direction)                                     
        ->paginate(10);
        return view('livewire.admin.descripcion.show-descripcion', compact('descripcions', 'servicios'));
    }
}
