<?php

namespace App\Http\Livewire\Admin\Direccion;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Direccion;
use App\Models\Servicio;
use Illuminate\Support\Facades\Storage;

class ShowDireccion extends Component
{
    use WithFileUploads;
   
    public $direccion, $image, $identificador;
    public $confirmDelete = false;
    public $open_edit = false;

    protected $listeners = ['render' => 'render', 'delete']; 

    public function mount(){
        $this->identificador = rand();
        $this->direccion = new Direccion();
    }
    protected $rules =[
        'direccion.direccion' => 'required', 
        'direccion.url' => 'required',         
        'direccion.dias' => 'required',  
        'direccion.horario' => 'required',  
        // 'direccion.image' => 'required|image'
    ];

    public function edit(Direccion $direccion){
        $this->direccion = $direccion;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->direccion->image]);
            $this->direccion->image = $this->image->store('portadas', 'public');
        }
       
        $this->direccion->save();
        $this->emit('render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo correctamente');
    
    }

    public function render()
    {
        $servicios = Servicio::all();
        $direccions = Direccion::all();
        return view('livewire.admin.direccion.show-direccion', compact('direccions', 'servicios'));
    }
}
