<?php

namespace App\Http\Livewire\Admin\Historial;

use Livewire\Component;
use App\Models\Profesional;
use App\Models\Historial;

class CreateHistorial extends Component
{
    public $open_create = false;
    public $profesional_id, $trayectoria;

    public function mount(Profesional $profesional){
        $this->profesional = $profesional;
    }
    protected $rules =[
        'trayectoria' => 'required',
        'profesional_id' => 'required',               
    ]; 

    public function create(Profesional $profesional){
        $this->profesional = $profesional;
        $this->open_create= true;
        $this->profesional_id= $profesional->id;
    }
    public function save(){
        
        $this->validate();

        Historial::create([
            'profesional_id' => $this->profesional_id,
            'trayectoria' => $this->trayectoria,            
        ]);
        $this->reset(['open_create', 'trayectoria', 'profesional_id']);
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Historial');
    }

    public function render()
    {
        $profesionals= Profesional::all();        
        $historials = Historial::all();
        return view('livewire.admin.historial.create-historial', compact('historials', 'profesionals'));
    }
}
