<?php

namespace App\Http\Livewire\Admin\Historial;

use Livewire\Component;
use App\Models\Profesional;
use App\Models\Historial;

class ShowHistorial extends Component
{
    public $profesional, $historial;
    public $open = false;
    // public $open_create = false;
    public $open_edit = false;
    public $confirmDelete = false;
    // public $profesional_id, $trayectoria;

    public function mount(Profesional $profesional){
        $this->profesional = $profesional;
    }
  
    protected $listeners = ['render' => 'render', 'delete'];
    protected $rules =[
        // 'profesional_id' => 'required', 
        // 'trayectoria' => 'required', 
        'historial.trayectoria' => 'required',
        'historial.profesional_id' => 'required',               
    ]; 

    // public function create(Profesional $profesional){
    //     $this->profesional = $profesional;
    //     $this->open_create= true;
    //     $this->profesional_id= $profesional->id;
    // }
    // public function save(){
        
    //     $this->validate();

    //     Historial::create([
    //         'profesional_id' => $this->profesional_id,
    //         'trayectoria' => $this->trayectoria,            
    //     ]);
    //     $this->reset(['open_create', 'trayectoria', 'profesional_id']);
    //     $this->emit('render');
    //     $this->emit('alert', 'Añadio un nuevo Historial');
    // }
    public function edit(Historial $historial){
        $this->historial = $historial;
        $this->open_edit = true;
    }
    public function update(){    
         $this->validate();   
       
        $this->historial->save();
        $this->emit('render');
        $this->reset('open_edit');
        $this->emit('alert', 'Se Actualizo el Historial');
   
    }
    public function historialDelete($id){
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteHistorial(Historial $historial){
        $historial->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        $profesionals= Profesional::all();        
        $historials = Historial::all();
        return view('livewire.admin.historial.show-historial', compact('historials', 'profesionals'));
    }
}
