<?php

namespace App\Http\Livewire\Admin\Icon;

use Livewire\Component;
use App\Models\icons;

class CreateIcon extends Component
{
    public $open = false;
    public $icon, $url;
    public function save(){

        $this->validate([
            'icon' => 'required',
        'url' => 'required',
        ]);      
              

        icons::create([            
            'icon' => $this->icon,
            'url' => $this->url,
            
        ]);
        $this->reset(['open', 'icon', 'url',]);       
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Icono');
    }

    public function render()
    {
        return view('livewire.admin.icon.create-icon');
    }
}
