<?php

namespace App\Http\Livewire\Admin\Icon;

use Livewire\Component;
use App\Models\icons;
use Livewire\WithPagination;

class ShowIcon extends Component
{
    use WithPagination;

    public $search, $icon, $url, $identificador;
    public $sort = 'id';
    public $direction = 'desc';
    public $confirmDelete = false;
    public $open_edit = false;

    public function mount()
    {
        $this->identificador = rand();
        $this->icon = new icons();
    }
    protected $rules =[
        'icon.icon' => 'required',
        'icon.url' => 'required',        
    ];

    protected $listeners = ['render' => 'render', 'delete'];
    public function order($sort)
    {
        if ($this->sort == $sort) {

            if ($this->direction == 'desc') {
                $this->direction = 'asc';
            } else {
                $this->direction = 'desc';
            }
        } else {
            $this->sort = $sort;
            $this->direction = 'asc';
        }
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }  

    public function edit(icons $icon)
    {
        $this->icon = $icon;
        $this->open_edit = true;
    }
    public function update() {
        $this->validate(); 
        

        $this->icon->save();
        $this->emit('render');
        $this->reset('open_edit');
        $this->emit('alert', 'Se Actualizo el Especialista');
    }
    public function iconDelete($id)
    {
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteIcon(icons $icon)
    {
        $icon->delete();
        $this->confirmDelete = false;
    }
    public function profesionalDelete($id)
    {
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteProfesional(icons $icon)
    {
        $icon->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        $icons = icons::where('icon', 'like', '%' . $this->search . '%')
            ->orderBy($this->sort, $this->direction)
            ->paginate(10);
        return view('livewire.admin.icon.show-icon',  compact('icons'));
    }
}
