<?php

namespace App\Http\Livewire\Admin\Portada;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Portada;
use Illuminate\Support\Facades\Storage;

class Portadas extends Component
{
    use WithPagination;
    use WithFileUploads;
    public $portada, $image, $identificador;
    public $sort = 'id';
    public $direction = 'desc';
    public $confirmDelete = false;
    public $open_edit = false;

    public function mount(){
        $this->identificador = rand();
        $this->portada = new Portada();
    }
    public function updatingSearch(){
        $this->resetPage();
    }
    protected $listeners = ['render' => 'render', 'delete'];   

    protected $rules =[
        'portada.title' => 'required',        
        // 'portada.image' => 'required|image'
    ];
    public function edit(Portada $portada){
        $this->portada = $portada;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->portada->image]);
            $this->portada->image = $this->image->store('portadas', 'public');
        }
       
        $this->portada->save();
        $this->emitTo('portada.portadas','render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo la Portada');
    
    }
    public function render()
    {      
        $portadas = Portada::all();  
        return view('livewire.admin.portada.portadas', compact('portadas'));
    }
}
