<?php

namespace App\Http\Livewire\Admin\Profesional;

use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\Profesional;

class CreateProfesional extends Component
{
    use WithFileUploads;
    
    public $open = false;
    public $nombres, $especialidad, $area, $descripcion, $image, $identificador;
    public $trayectoria, $especialista_id;

    public function mount(){
        $this->identificador = rand();
    }
    protected $rules = [        
        'nombres' => 'required',
        'especialidad' => 'required',
        'area' => 'required',
        'descripcion' => 'required',
        'image' => 'required|image'
    ];
    public function save(){

        $this->validate();
       
        $image = $this->image->store('profesionals', 'public');        

        Profesional::create([            
            'nombres' => $this->nombres,
            'especialidad' => $this->especialidad,
            'area' => $this->area,
            'descripcion' => $this->descripcion,
            'image' => $image
        ]);
        $this->reset(['open', 'nombres', 'especialidad', 'area', 'descripcion', 'image']);
        $this->identificador = rand();
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Especialista');
    }


    public function render()
    {
        return view('livewire.admin.profesional.create-profesional');
    }
}
