<?php

namespace App\Http\Livewire\Admin\Profesional;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Profesional;
use Illuminate\Support\Facades\Storage;

class ShowProfesional extends Component
{

    use WithPagination;
    use WithFileUploads;

    public $search, $profesional, $image, $identificador;
    public $sort = 'id';
    public $direction = 'desc';
    public $confirmDelete = false;
    public $open_edit = false;

    public function mount(){
        $this->identificador = rand();
        $this->profesional = new Profesional();
    }
    public function updatingSearch(){
        $this->resetPage();
    }
    protected $listeners = ['render' => 'render', 'delete'];
    public function order($sort){
        if ($this->sort == $sort) {

            if($this->direction == 'desc'){
                $this->direction = 'asc';
            } else{
                $this->direction = 'desc';
            }
        } else {
            $this->sort = $sort;
            $this->direction = 'asc';
        }
      
    }

    protected $rules =[
        'profesional.nombres' => 'required',
        'profesional.especialidad' => 'required',
        'profesional.area' => 'required',
        'profesional.descripcion' => 'required',
        // 'profesional.image' => 'required|image'
    ];
    public function edit(Profesional $profesional){
        $this->profesional = $profesional;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->profesional->image]);
            $this->profesional->image = $this->image->store('profesionals', 'public');
        }
       
        $this->profesional->save();
        $this->emit('render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo el Especialista');

    
    }
    public function profesionalDelete($id){
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteProfesional(Profesional $profesional){
        $profesional->delete();
        $this->confirmDelete = false;
    }
    public function render()
    {
        $profesionals = Profesional::where('nombres','like', '%' .$this->search . '%')
        ->orwhere('especialidad','like', '%' .$this->search . '%')
        ->orwhere('area','like', '%' .$this->search . '%')   
        ->orderBy($this->sort, $this->direction)                                     
        ->paginate(10);
        return view('livewire.admin.profesional.show-profesional',  compact('profesionals'));
    }
}
