<?php

namespace App\Http\Livewire\Admin\Servicios;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Servicio;
use Illuminate\Support\Facades\Storage;

class CreateService extends Component
{
    use WithFileUploads;
    
    public $open = false;
    public $servicio, $descripcion, $image;  

    public function mount(){
        $this->identificador = rand();
    }
    protected $rules = [        
        'servicio' => 'required',
        'descripcion' => 'required',        
        'image' => 'required|image'
    ];
    public function save(){

        $this->validate();
       
        $image = $this->image->store('profesionals', 'public');        

        Servicio::create([            
            'servicio' => $this->servicio,
            'descripcion' => $this->descripcion,
            'image' => $image
        ]);
        $this->reset(['open', 'servicio', 'descripcion', 'image']);
        $this->identificador = rand();
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Servcio');
    }
    public function render()
    {
        
        return view('livewire.admin.servicios.create-service');
    }
}
