<?php

namespace App\Http\Livewire\Admin\Servicios;


use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use App\Models\Servicio;
use Illuminate\Support\Facades\Storage;

class ShowService extends Component
{
    use WithPagination;
    use WithFileUploads;

    public $search, $servicio, $image, $identificador;
    public $sort = 'id';
    public $direction = 'desc';
    public $confirmDelete = false;
    public $open_edit = false;

    public function mount(){
        $this->identificador = rand();
        $this->servicio = new Servicio();
    }
    public function updatingSearch(){
        $this->resetPage();
    }
    protected $listeners = ['render' => 'render', 'delete'];
    public function order($sort){
        if ($this->sort == $sort) {

            if($this->direction == 'desc'){
                $this->direction = 'asc';
            } else{
                $this->direction = 'desc';
            }
        } else {
            $this->sort = $sort;
            $this->direction = 'asc';
        }
      
    }

    protected $rules =[
        'servicio.servicio' => 'required',        
        'servicio.descripcion' => 'required',
        // 'servicio.image' => 'required|image'
    ];
    public function edit(Servicio $servicio){
        $this->servicio = $servicio;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->servicio->image]);
            $this->servicio->image = $this->image->store('servicios', 'public');
        }
       
        $this->servicio->save();
        $this->emit('render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo el Especialista');

    
    }
    public function servicioDelete($id){
        $this->confirmDelete = $id;
    }
    public function deleteServicio(Servicio $servicio){
        $servicio->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        // $servicios = Servicio::where('servicio','like', '%' .$this->search . '%')
        // ->orwhere('descripcion','like', '%' .$this->search . '%')  
        // ->orderBy($this->sort, $this->direction)                                     
        // ->paginate(10);
        $servicios = Servicio::all();       
              
        return view('livewire.admin.servicios.show-service', compact('servicios'));
    }
}
