<?php

namespace App\Http\Livewire\Admin\Slider;

use Livewire\Component;
use App\Models\Inicio;
use Illuminate\Support\Facades\Storage;
use Livewire\WithFileUploads;

use function GuzzleHttp\Promise\all;

class ShowSlider extends Component
{
    use WithFileUploads;
   
    public $slider, $image, $identificador;
    public $confirmDelete = false;
    public $open_edit = false;

    protected $listeners = ['render' => 'render', 'delete']; 

    public function mount(){
        $this->identificador = rand();
        $this->slider = new Inicio();
    }
    protected $rules =[
        'slider.titulo' => 'required', 
        'slider.subtitulo' => 'required',         
         
        // 'direccion.image' => 'required|image'
    ];

    public function edit(Inicio $slider){
        $this->slider = $slider;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        if($this->image){
            Storage::delete([$this->slider->image]);
            $this->slider->image = $this->image->store('portadas', 'public');
        }
       
        $this->slider->save();
        $this->emit('render');
        $this->reset('open_edit', 'image');
        $this->emit('alert', 'Se Actualizo correctamente');
    
    }

    public function render()
    {
        $inicios = Inicio::all();
        return view('livewire.admin.slider.show-slider', compact('inicios'));
    }
}
