<?php

namespace App\Http\Livewire\Admin\Social;

use Livewire\Component;
use App\Models\Social;
use App\Models\icons;

class CreateSocial extends Component
{
    public $open = false;
    public $icon, $nombre, $url;

    protected $rules = [        
        'icon' => 'required',
        'nombre' => 'required',        
        'url' => 'required'
    ];
    public function save(){

        $this->validate();             

        Social::create([            
            'icon' => $this->icon,
            'nombre' => $this->nombre,
            'url' => $this->url,
        ]);
        $this->reset(['open', 'icon', 'nombre', 'url']);
        $this->emit('render');
        $this->emit('alert', 'Se añadio correctamente');
    }

    public function render()
    {
        $iconos= icons::all(); 
        return view('livewire.admin.social.create-social', compact('iconos'));
    }
}
