<?php

namespace App\Http\Livewire\Admin\Social;

use App\Models\icons;
use Livewire\Component;
use App\Models\Social;

class ShowSocial extends Component
{
    public $confirmDelete = false;
    public $open_edit = false;
    public $social;

    protected $listeners = ['render' => 'render', 'delete'];
    protected $rules =[        
        'social.icon' => 'required',
        'social.nombre' => 'required',         
        'social.url' => 'required',                 
    ]; 
    public function mount(){        
        $this->social = new Social();
    }

    public function edit(Social $social){
        $this->social = $social;
        $this ->open_edit = true;
    }
    public function update(){    
         $this->validate();    
        
        $this->social->save();
        $this->emit('render');
        $this->reset('open_edit');
        $this->emit('alert', 'Se Actualizo el correctamente');

    
    }
    public function socialDelete($id){
        
        $this->confirmDelete = $id;
    }
    public function deleteSocial(Social $social){
        $social->delete();
        $this->confirmDelete = false;
    }
    public function render()
    {
        $socials= Social::all(); 
        $iconos= icons::all(); 
        return view('livewire.admin.social.show-social', compact('socials', 'iconos'));
    }
}
