<?php

namespace App\Http\Livewire\Admin\User;

use App\Models\User;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Livewire\Component;

class CreateUser extends Component
{
    public $open = false;
    public $name, $email, $password;
   
    protected function passwordRules()
    {
        return ['required', 'string', new Password, 'confirmed'];
    }
    protected $rules = [
        'name' => 'required|string',
        'email' => 'required|email|string|max:255|unique:users',
        'password' =>'required|string|min:8',
    ];
    public function save(){
        $this->validate();
        User::create([
            'name' => $this->name,
            'email' => $this->email,  
            'password' => Hash::make($this->password,),
            
                      
        ]);
        $this->reset(['open','name', 'email', 'password']);
       
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Usuario');
    }

    public function render()
    {
        return view('livewire.admin.user.create-user');
    }
}
