<?php

namespace App\Http\Livewire\Admin\User;

use Livewire\Component;
use App\Models\User;
use Livewire\WithPagination;

class ShowUser extends Component
{
    use WithPagination;

    public $search, $user;
    public $contador = 1;
    public $sort = 'id';
    public $direction = 'desc';
    protected $listeners = ['render' => 'render', 'delete'];
    public $confirmDelete = false;

    public function updatingSearch(){
        $this->resetPage();
    }
    public function usuarioDelete($id){
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteUsuario(User $usuario){
       
        $usuario->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        $users = User::where('name','like', '%' .$this->search . '%')                                       
        ->orwhere('email','like', '%' .$this->search . '%')
        ->orderBy($this->sort, $this->direction)                                     
        ->paginate(10);
        return view('livewire.admin.user.show-user', compact('users'));
    }
    public function order($sort){
        if ($this->sort == $sort) {

            if($this->direction == 'desc'){
                $this->direction = 'asc';
            } else{
                $this->direction = 'desc';
            }
        } else {
            $this->sort = $sort;
            $this->direction = 'asc';
        }
      
    }
}
