<?php

namespace App\Http\Livewire\Admin\Vineta;
use App\Models\Descripcion;
use App\Models\Vineta;

use Livewire\Component;

class CreateVineta extends Component
{
    public $open_create = false;
    public $descripcion_id, $lista;

    public function mount(Descripcion $descripcion){
        $this->descripcion = $descripcion;
    }
    protected $rules =[        
        'descripcion_id' => 'required', 
        'lista' => 'required',                
    ]; 
    public function create(Descripcion $descripcion){
        $this->descripcion = $descripcion;
        $this->open_create= true;
        $this->descripcion_id= $descripcion->id;
    }
    public function save(){
        
        $this->validate();

        Vineta::create([
            'descripcion_id' => $this->descripcion_id,
            'lista' => $this->lista,            
        ]);
        $this->reset(['open_create', 'lista', 'descripcion_id']);
        $this->emit('render');
        $this->emit('alert', 'Añadio un nuevo Vineta');
    }

    public function render()
    {
        $vinetas= Vineta::all();        
        $descripcions = Descripcion::all();
        return view('livewire.admin.vineta.create-vineta', compact('vinetas', 'descripcions'));
    }
}
