<?php

namespace App\Http\Livewire\Admin\Vineta;

use Livewire\Component;
use App\Models\Descripcion;
use App\Models\Vineta;

class ShowVineta extends Component
{
    public $descripcion, $vineta;
    public $open = false;
    // public $open_create = false;
    public $open_edit = false;
    public $confirmDelete = false;
    // public $descripcion_id, $lista;

    public function mount(Descripcion $descripcion){
        $this->descripcion = $descripcion;
    }
    protected $listeners = ['render' => 'render', 'delete'];

    protected $rules =[        
        'vineta.lista' => 'required',
        'vineta.descripcion_id' => 'required',         
        // 'descripcion_id' => 'required', 
        // 'lista' => 'required',                
    ]; 

    // public function create(Descripcion $descripcion){
    //     $this->descripcion = $descripcion;
    //     $this->open_create= true;
    //     $this->descripcion_id= $descripcion->id;
    // }
    // ('descripcion_id');
    // public function save(){
        
    //     // $this->validate();

    //     Vineta::create([
    //         'descripcion_id' => $this->descripcion_id,
    //         'lista' => $this->lista,            
    //     ]);
    //     $this->reset(['open_create', 'lista', 'descripcion_id']);
    //     $this->emit('render');
    //     $this->emit('alert', 'Añadio un nuevo Vineta');
    // }
    public function edit(Vineta $vineta){
        $this->vineta = $vineta;
        $this->open_edit = true;
    }
    public function update(){    
         $this->validate();   
       
        $this->vineta->save();
        $this->emit('render');
        $this->reset('open_edit');
        $this->emit('alert', 'Se Actualizo el Descripcion');
   
    }
    public function vinetaDelete($id){
        // $especialista->delete();
        $this->confirmDelete = $id;
    }
    public function deleteVineta(Vineta $vineta){
        $vineta->delete();
        $this->confirmDelete = false;
    }

    public function render()
    {
        $descripcions = Descripcion::all();
        $vinetas = Vineta::all();
        return view('livewire.admin.vineta.show-vineta', compact('vinetas', 'descripcions'));
    }
}
